create or replace package tbicds.PCK_UTL_EXPORT_DATA
AUTHID CURRENT_USER 
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   -- Public constant declarations
   c_nShowNotIncluded          constant number := 1;
   c_nShowLatestIntakeOnly     constant number := 0;

   -- demoValue_STAT
   function demoValue_STAT (
      pi_vVariableName                  in varchar2,
      pi_vVariableValue                 in varchar2
      ) return                             varchar2;

   -- demoValue_TBL
   function demoValue_TBL (
      pi_vVariableName                  in varchar2,
      pi_vPatientID                     in varchar2
      ) return                             varchar2;

   -- demoValue_SE
   function demoValue_SE (
      pi_vVariableName                  in varchar2,
      pi_vPatientID                     in varchar2
      ) return                             varchar2;

   -- latestResponseValue
   function latestResponseValue (
      pi_vPatientID                     in varchar2,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number
      ) return                             varchar2;
   
   -- latestResponseValue_Radio
   function latestResponseValue_Radio (
      pi_vPatientID                     in varchar2,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number
      ) return                             varchar2;

   -- generateCsv()
   procedure generateCsv (
      pi_nRequestID                     in number,
      pi_vKey                           in varchar2
      );
   
   -- runExport()
   procedure runExport (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      pi_nRequestID                     in number,
      pi_vKey                           in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2
      );

   -- cancelExport()
   procedure cancelExport (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      pi_nRequestID                     in number,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2
      );

end;
/

